<?php

/**

 * Template part for displaying page content in page.php.

 *

 * @link https://codex.wordpress.org/Template_Hierarchy

 *

 * @package Flash

 */



?>



<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>



	<?php

	/**

	 * flash_before_post_content hook

	 */

	do_action( 'flash_before_post_content' ); ?>



	<div class="entry-content">

		<?php

			the_content();



			wp_link_pages( array(

				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'flash' ),

				'after'  => '</div>',

			) );

		?>

	</div><!-- .entry-content -->



	<?php if ( get_edit_post_link() ) : ?>

		<footer class="entry-footer">

			<?php

				edit_post_link(

					sprintf(

						/* translators: %s: Name of current post */

						esc_html__( 'Edit %s', 'flash' ),

						the_title( '<span class="screen-reader-text">"', '"</span>', false )

					),

					'<span class="edit-link">',

					'</span>'

				);

			?>

		</footer><!-- .entry-footer -->

	<?php endif; ?>



	<?php

	/**

	 * flash_after_post_content hook

	 */

	do_action( 'flash_after_post_content' ); ?>



</article><!-- #post-## -->

