<?php

/**

 * Customizer Control: slider.

 *

 * Creates a jQuery slider control.

 *

 * @package     Kirki

 * @subpackage  Controls

 * @copyright   Copyright (c) 2016, Aristeides Stathopoulos

 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT

 * @since       1.0

 */



// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



if ( ! class_exists( 'Kirki_Controls_Slider_Control' ) ) {



	/**

	 * Slider control (range).

	 */

	class Kirki_Controls_Slider_Control extends Kirki_Customize_Control {



		/**

		 * The control type.

		 *

		 * @access public

		 * @var string

		 */

		public $type = 'kirki-slider';



		/**

		 * Refresh the parameters passed to the JavaScript via JSON.

		 *

		 * @access public

		 */

		public function to_json() {

			parent::to_json();

			$this->json['choices']['min']  = ( isset( $this->choices['min'] ) ) ? $this->choices['min'] : '0';

			$this->json['choices']['max']  = ( isset( $this->choices['max'] ) ) ? $this->choices['max'] : '100';

			$this->json['choices']['step'] = ( isset( $this->choices['step'] ) ) ? $this->choices['step'] : '1';

		}



		/**

		 * Enqueue control related scripts/styles.

		 *

		 * @access public

		 */

		public function enqueue() {

			wp_enqueue_script( 'kirki-slider' );

		}



		/**

		 * An Underscore (JS) template for this control's content (but not its container).

		 *

		 * Class variables for this control class are available in the `data` JS object;

		 * export custom variables by overriding {@see Kirki_Customize_Control::to_json()}.

		 *

		 * @see WP_Customize_Control::print_template()

		 *

		 * @access protected

		 */

		protected function content_template() {

			?>

			<# if ( data.tooltip ) { #>

				<a href="#" class="tooltip hint--left" data-hint="{{ data.tooltip }}"><span class='dashicons dashicons-info'></span></a>

			<# } #>

			<label>

				<# if ( data.label ) { #>

					<span class="customize-control-title">{{{ data.label }}}</span>

				<# } #>

				<# if ( data.description ) { #>

					<span class="description customize-control-description">{{{ data.description }}}</span>

				<# } #>

				<div class="wrapper">

					<input {{{ data.inputAttrs }}} type="range" min="{{ data.choices['min'] }}" max="{{ data.choices['max'] }}" step="{{ data.choices['step'] }}" value="{{ data.value }}" {{{ data.link }}} data-reset_value="{{ data.default }}" />

					<div class="kirki_range_value">

						<span class="value">{{ data.value }}</span>

						<# if ( data.choices['suffix'] ) { #>

							{{ data.choices['suffix'] }}

						<# } #>

					</div>

					<div class="kirki-slider-reset">

						<span class="dashicons dashicons-image-rotate"></span>

					</div>

				</div>

			</label>

			<?php

		}

	}

}

