<?php

/**

 * Customizer Control: sortable.

 *

 * @package     Kirki

 * @subpackage  Controls

 * @copyright   Copyright (c) 2017, Aristeides Stathopoulos

 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT

 * @since       1.0

 */



// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



/**

 * Sortable control (uses checkboxes).

 */

class Kirki_Control_Sortable extends WP_Customize_Control {



	/**

	 * The control type.

	 *

	 * @access public

	 * @var string

	 */

	public $type = 'kirki-sortable';



	/**

	 * Used to automatically generate all CSS output.

	 *

	 * @access public

	 * @var array

	 */

	public $output = array();



	/**

	 * Data type

	 *

	 * @access public

	 * @var string

	 */

	public $option_type = 'theme_mod';



	/**

	 * Enqueue control related scripts/styles.

	 *

	 * @access public

	 */

	public function enqueue() {



		wp_enqueue_script( 'kirki-sortable', trailingslashit( Kirki::$url ) . 'controls/sortable/sortable.js', array( 'jquery', 'customize-base', 'jquery-ui-core', 'jquery-ui-sortable' ), false, true );

		wp_enqueue_style( 'kirki-sortable-css', trailingslashit( Kirki::$url ) . 'controls/sortable/sortable.css', null );

	}



	/**

	 * Refresh the parameters passed to the JavaScript via JSON.

	 *

	 * @see WP_Customize_Control::to_json()

	 */

	public function to_json() {

		parent::to_json();



		$this->json['default'] = $this->setting->default;

		if ( isset( $this->default ) ) {

			$this->json['default'] = $this->default;

		}

		$this->json['output']  = $this->output;

		$this->json['value']   = maybe_unserialize( $this->value() );

		$this->json['choices'] = $this->choices;

		$this->json['link']    = $this->get_link();

		$this->json['id']      = $this->id;



		$this->json['inputAttrs'] = '';

		foreach ( $this->input_attrs as $attr => $value ) {

			$this->json['inputAttrs'] .= $attr . '="' . esc_attr( $value ) . '" ';

		}

		$this->json['inputAttrs'] = maybe_serialize( $this->input_attrs() );



	}



	/**

	 * An Underscore (JS) template for this control's content (but not its container).

	 *

	 * Class variables for this control class are available in the `data` JS object;

	 * export custom variables by overriding {@see WP_Customize_Control::to_json()}.

	 *

	 * @see WP_Customize_Control::print_template()

	 *

	 * @access protected

	 */

	protected function content_template() {

		?>

		<div class="kirki-controls-loading-spinner"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>

		<label class='kirki-sortable'>

			<span class="customize-control-title">

				{{{ data.label }}}

			</span>

			<# if ( data.description ) { #>

				<span class="description customize-control-description">{{{ data.description }}}</span>

			<# } #>



			<ul class="sortable">

				<# _.each( data.value, function( choiceID ) { #>

					<li {{{ data.inputAttrs }}} class='kirki-sortable-item' data-value='{{ choiceID }}'>

						<i class='dashicons dashicons-menu'></i>

						<i class="dashicons dashicons-visibility visibility"></i>

						{{{ data.choices[ choiceID ] }}}

					</li>

				<# }); #>

				<# _.each( data.choices, function( choiceLabel, choiceID ) { #>

					<# if ( -1 === data.value.indexOf( choiceID ) ) { #>

						<li {{{ data.inputAttrs }}} class='kirki-sortable-item invisible' data-value='{{ choiceID }}'>

							<i class='dashicons dashicons-menu'></i>

							<i class="dashicons dashicons-visibility visibility"></i>

							{{{ data.choices[ choiceID ] }}}

						</li>

					<# } #>

				<# }); #>

			</ul>

		</label>



		<?php

	}



	/**

	 * Render the control's content.

	 *

	 * @see WP_Customize_Control::render_content()

	 */

	protected function render_content() {}

}

