<?php

/**

 * Customizer Control: radio-buttonset.

 *

 * @package     Kirki

 * @subpackage  Controls

 * @copyright   Copyright (c) 2016, Aristeides Stathopoulos

 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT

 * @since       1.0

 */



// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



if ( ! class_exists( 'Kirki_Controls_Radio_Buttonset_Control' ) ) {



	/**

	 * Radio Buttonset control (modified radio)

	 */

	class Kirki_Controls_Radio_Buttonset_Control extends Kirki_Customize_Control {



		/**

		 * The control type.

		 *

		 * @access public

		 * @var string

		 */

		public $type = 'kirki-radio-buttonset';



		/**

		 * Enqueue control related scripts/styles.

		 *

		 * @access public

		 */

		public function enqueue() {

			wp_enqueue_script( 'kirki-radio-buttonset' );

		}



		/**

		 * An Underscore (JS) template for this control's content (but not its container).

		 *

		 * Class variables for this control class are available in the `data` JS object;

		 * export custom variables by overriding {@see Kirki_Customize_Control::to_json()}.

		 *

		 * @see WP_Customize_Control::print_template()

		 *

		 * @access protected

		 */

		protected function content_template() {

			?>

			<# if ( data.tooltip ) { #>

				<a href="#" class="tooltip hint--left" data-hint="{{ data.tooltip }}"><span class='dashicons dashicons-info'></span></a>

			<# } #>

			<# if ( data.label ) { #>

				<span class="customize-control-title">{{{ data.label }}}</span>

			<# } #>

			<# if ( data.description ) { #>

				<span class="description customize-control-description">{{{ data.description }}}</span>

			<# } #>

			<div id="input_{{ data.id }}" class="buttonset">

				<# for ( key in data.choices ) { #>

					<input {{{ data.inputAttrs }}} class="switch-input" type="radio" value="{{ key }}" name="_customize-radio-{{{ data.id }}}" id="{{ data.id }}{{ key }}" {{{ data.link }}}<# if ( key === data.value ) { #> checked="checked" <# } #>>

						<label class="switch-label switch-label-<# if ( key === data.value ) { #>on <# } else { #>off<# } #>" for="{{ data.id }}{{ key }}">

							{{ data.choices[ key ] }}

						</label>

					</input>

				<# } #>

			</div>

			<?php

		}

	}

}

