<?php

/**

 * Customizer Control: kirki-date.

 *

 * @package     Kirki

 * @subpackage  Controls

 * @copyright   Copyright (c) 2016, Aristeides Stathopoulos

 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT

 * @since       2.2

 */



// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



if ( ! class_exists( 'Kirki_Controls_Date_Control' ) ) {



	/**

	 * A simple date control, using jQuery UI.

	 */

	class Kirki_Controls_Date_Control extends Kirki_Customize_Control {



		/**

		 * The control type.

		 *

		 * @access public

		 * @var string

		 */

		public $type = 'kirki-date';



		/**

		 * Enqueue control related scripts/styles.

		 *

		 * @access public

		 */

		public function enqueue() {

			wp_enqueue_script( 'kirki-date' );

		}



		/**

		 * An Underscore (JS) template for this control's content (but not its container).

		 *

		 * Class variables for this control class are available in the `data` JS object;

		 * export custom variables by overriding {@see Kirki_Customize_Control::to_json()}.

		 *

		 * @see WP_Customize_Control::print_template()

		 *

		 * @access protected

		 */

		protected function content_template() {

			?>

			<# if ( data.tooltip ) { #>

				<a href="#" class="tooltip hint--left" data-hint="{{ data.tooltip }}"><span class='dashicons dashicons-info'></span></a>

			<# } #>

			<label>

				<# if ( data.label ) { #>

					<span class="customize-control-title">{{{ data.label }}}</span>

				<# } #>

				<# if ( data.description ) { #>

					<span class="description customize-control-description">{{{ data.description }}}</span>

				<# } #>

				<div class="customize-control-content">

					<input {{{ data.inputAttrs }}} class="datepicker" type="text" id="{{ data.id }}" value="{{ data.value }}" {{{ data.link }}} />

				</div>

			</label>

			<?php

		}

	}

}

