<?php

/**

 * Customizer Control: switch.

 *

 * @package     Kirki

 * @subpackage  Controls

 * @copyright   Copyright (c) 2017, Aristeides Stathopoulos

 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT

 * @since       1.0

 */



// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



/**

 * Switch control (modified checkbox).

 */

class Kirki_Control_Switch extends Kirki_Control_Base {



	/**

	 * The control type.

	 *

	 * @access public

	 * @var string

	 */

	public $type = 'kirki-switch';



	/**

	 * An Underscore (JS) template for this control's content (but not its container).

	 *

	 * Class variables for this control class are available in the `data` JS object;

	 * export custom variables by overriding {@see WP_Customize_Control::to_json()}.

	 *

	 * @see WP_Customize_Control::print_template()

	 *

	 * @access protected

	 */

	protected function content_template() {

		?>

		<div class="switch<# if ( data.choices['round'] ) { #> round<# } #>">

			<span class="customize-control-title">

				{{{ data.label }}}

			</span>

			<# if ( data.description ) { #>

				<span class="description customize-control-description">{{{ data.description }}}</span>

			<# } #>

			<input class="screen-reader-text" {{{ data.inputAttrs }}} name="switch_{{ data.id }}" id="switch_{{ data.id }}" type="checkbox" value="{{ data.value }}" {{{ data.link }}}<# if ( '1' == data.value ) { #> checked<# } #> />

			<label class="switch-label" for="switch_{{ data.id }}">

				<span class="switch-on">

					<# data.choices.on = data.choices.on || '<?php esc_attr_e( 'On', 'kirki' ); ?>' #>

					{{ data.choices.on }}

				</span>

				<span class="switch-off">

					<# data.choices.off = data.choices.off || '<?php esc_attr_e( 'Off', 'kirki' ); ?>' #>

					{{ data.choices.off }}

				</span>

			</label>

		</div>

		<?php

	}

}

